<?php
/**
 * @package Legacy
 * @version $Id: MiscSmiliesAction.class.php,v 1.1.2.1.2.2 2006/10/13 09:20:07 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/forms/SmilesFilterForm.class.php";

class Legacy_MiscSmiliesAction extends Legacy_AbstractListAction
{
	/**
	 * @var string
	 */
	var $mTargetName = null;

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('smiles', 'base');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new Legacy_SmilesFilterForm($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	function _getBaseUrl()
	{
		return "./misc.php?type=Smilies";
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mTargetName = xoops_getrequest('target');
		return parent::getDefaultView($controller, $xoopsUser);
	}
	
	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		//
		// Because this action's template uses BASE message catalog, load it.
		//
		$root =& $controller->mRoot;
		$root->mLanguageManager->loadModuleMessageCatalog('base');
		
		$render->setTemplateName("legacy_misc_smilies.html");
		$render->setAttribute("objects", $this->mObjects);
		$render->setAttribute("pageNavi", $this->mFilter->mNavi);
		$render->setAttribute("targetName", $this->mTargetName);
	}
}

?>
