<?php
/**
 * @package Legacy
 * @version Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * The structure which have a policy and an information of a module, which
 * Legacy_Controller must know. In the later version, this class may be
 * replaced with just array.
 * 
 * For a performance, this class has reset() to reuse a object.
 */
class Legacy_AbstractCacheInformation
{
	/**
	 * Array of uid. This is an information for cache store program to generate
	 * an unique file name. Uid isn't must. Sets identity data.
	 * 
	 * @access public
	 * @var Array of uid
	 */
	var $mIdentityArr = array();
	
	/**
	 * Array of groupid. This is an information for cache store program to
	 * generate an unique file name.
	 * 
	 * @access public
	 * @var Array of groupid
	 */
	var $mGroupArr = array();

	/**
	 * Boolean flag indicating whether this object asks caching to the
	 * controller.
	 * 
	 * @access private
	 * @var bool
	 */	
	var $_mEnableCache = null;
	
	/**
	 * For a special cache mechanism, free to use hashmap.
	 * 
	 * @access public
	 * @var array
	 */
	var $mAttributes = array();
	
	function Legacy_AbstractCacheInformation()
	{
	}
	
	/**
	 * Gets a value indicating whether someone has tried to set a flag to this
	 * object.
	 * @return bool
	 */
	function hasSetEnable()
	{
		return $this->_mEnableCache !== false;
	}
	
	/**
	 * Sets a flag indicating whether this object decides executing cache.
	 * @param bool $flag
	 */
	function setEnableCache($flag)
	{
		$this->_mEnableCache = $flag;
	}
	
	/**
	 * Gets a flag indicating whether this object decides executing cache.
	 * @return bool
	 */
	function isEnableCache()
	{
		return $this->_mEnableCache;
	}
	
	/**
	 * Resets member properties to reuse this object.
	 */
	function reset()
	{
		$this->mIdentityArr = array();
		$this->mGroupArr = array();
		$this->_mEnableCache = null;
	}
}

class Legacy_ModuleCacheInformation extends Legacy_AbstractCacheInformation
{
	/**
	 * [READ ONLY] Xoops Module Object.
	 * 
	 * @access protected
	 * @var XoopsModule
	 */
	var $mModule = null;
	
	/**
	 * The current URL used as a base for a cache file name. This should be
	 * modified by modules to not make extra cache files.
	 * 
	 * @access public
	 * @var string
	 */
	var $mURL = null;

	/**
	 * Sets a module object.
	 * @param XoopsModule $module
	 */
	function setModule(&$module)
	{
		$this->mModule =& $module;
	}
	
	function reset()
	{
		parent::reset();
		$this->mModule = null;
		$this->mURL = null;
	}
}

class Legacy_BlockCacheInformation extends Legacy_AbstractCacheInformation
{
	/**
	 * [READ ONLY] Xoops Block Object.
	 * 
	 * @access protected
	 * @var XoopsBlock
	 */
	 var $mBlock = null;
	 
	 /**
	  * Sets a block object.
	  * 
	  * @param Legacy_AbstractBlockProcedure $blockProcedure
	  */
	 function setBlock(&$blockProcedure)
	 {
		 $this->mBlock =& $blockProcedure->_mBlock;
	 }
	 
	 function reset()
	 {
		 parent::reset();
		 $this->mBlock = null;
	 }
}

?>