<?php
/**
 * @package Legacy
 * @version $Id: Legacy_PublicControllerStrategy.class.php,v 1.1.2.8 2006/10/13 17:52:29 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

class Legacy_PublicControllerStrategy extends Legacy_AbstractControllerStrategy
{
	var $mStatusFlag = LEGACY_CONTROLLER_STATE_PUBLIC;
	
	function Legacy_PublicControllerStrategy(&$controller)
	{
		parent::Legacy_AbstractControllerStrategy($controller);
		
		$controller->mRoot->mContext->mBaseRenderSystemName = "Legacy_RenderSystem";
		
		if (!defined("LEGACY_DEPENDENCE_RENDERER")) {
			define("LEGACY_DEPENDENCE_RENDERER", "Legacy_RenderSystem");
		}
	}

	function setupBlock()
	{
		$showFlag =0;
		$mid=0;

		if($this->mController->mRoot->mContext->mModule != null) {
			$showFlag = (preg_match("/index\.php$/i", xoops_getenv('PHP_SELF')) && $this->mController->mConfig['startpage'] == $this->mController->mRoot->mContext->mXoopsModule->get('dirname'));
			$mid = $this->mController->mRoot->mContext->mXoopsModule->get('mid');
		}
		else {
			//
			// If you does not have module_contoller, this request is to toppage or other pages of toppage.
			//
			$mid = preg_match("/index\.php$/i", xoops_getenv('PHP_SELF')) ? -1 : 0;
		}

        $blockHandler =& xoops_gethandler('block');
		$showCenterFlag = (SHOW_CENTERBLOCK_LEFT | SHOW_CENTERBLOCK_CENTER | SHOW_CENTERBLOCK_RIGHT);
		$showRightFlag = SHOW_SIDEBLOCK_RIGHT;
		$showFlag = SHOW_SIDEBLOCK_LEFT | $showRightFlag | $showCenterFlag;
		$groups = is_object($this->mController->mRoot->mContext->mXoopsUser) ? $this->mController->mRoot->mContext->mXoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;

		$blockObjects =& $blockHandler->getBlocks($groups, $mid, $showFlag);
		foreach($blockObjects as $blockObject) {
			$block =& Legacy_Utils::createBlockProcedure($blockObject);

			if ($block->prepare() !== false) {
				$this->mController->_mBlockChain[] =& $block;
			}
			unset($block);
			unset($blockObject);
		}
	}

	function &getMainThemeObject()
	{
		// [TODO]
		// Because get() of the virtual handler is heavy, we have to consider
		// the new solution about this process.
		//
		$handler =& xoops_getmodulehandler('theme', 'base');
		$theme =& $handler->get($this->mController->getTheme());
		
		return $theme;
	}
	
	function isEnableCacheFeature()
	{
		return true;
	}
	
	function enableAccess()
	{
		if ($this->mController->mRoot->mContext->mModule != null) {
			$dirname = $this->mController->mRoot->mContext->mXoopsModule->get('dirname');
			
			return $this->mController->mRoot->mContext->mUser->isInRole("Module.${dirname}.Visitor");
		}
		
		return true;
	}
	
	function setupModuleLanguage()
	{
		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadModuleMessageCatalog($root->mContext->mXoopsModule->get('dirname'));
	}
}

?>