<?php
/**
 * @package user
 * @version $Id: LegacypageFunctions.class.php,v 1.1.2.11.2.4 2006/10/23 11:22:10 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();
 
/**
 * This is static functions collection class for legacy pages access.
 */
class User_LegacypageFunctions
{
	/**
	 * The process for userinfo.php. This process doesn't execute anything
	 * directly. Forward to the controller of the user module.
	 */
	function userinfo()
	{
		$root =& XCube_Root::getSingleton();
		
		$uid = isset($_REQUEST['uid']) ? intval(xoops_getrequest('uid')) : 0;
		
		$url = XOOPS_URL . '/';
		if ($uid > 0) {
			$url = XOOPS_MODULE_URL . "/user/index.php?action=UserInfo&uid=" . $uid;
		}
		else {
			$xoopsUser =& $root->mContext->mXoopsUser;
			if (is_object($xoopsUser)) {
				$url = XOOPS_MODULE_URL . "/user/index.php?action=UserInfo&uid=" . $xoopsUser->get('uid');
			}
		}
		
		$root->mController->executeForward($url);
	}
	
	/**
	 * The process for edituser.php. This process doesn't execute anything
	 * directly. Forward to the controller of the user module.
	 */
	function edituser()
	{
		$root =& XCube_Root::getSingleton();
		$uid = isset($_REQUEST['uid']) ? intval(xoops_getrequest('uid')) : 0;

		$url = XOOPS_URL . '/';
		if ($uid > 0) {
			$url = XOOPS_MODULE_URL . "/user/index.php?action=EditUser&uid=" . $uid;
		}
		else {
			$xoopsUser =& $root->mContext->mXoopsUser;
			if (is_object($xoopsUser)) {
				$url = XOOPS_MODULE_URL . "/user/index.php?action=EditUser&uid=" . $xoopsUser->get('uid');
			}
		}

		$root->mController->executeForward($url);
	}
	
	/**
	 * The process for register.php. This process doesn't execute anything
	 * directly. Forward to the controller of the user module.
	 */
	function register()
	{
		$root =& XCube_Root::getSingleton();
		$xoopsUser =& $root->mContext->mXoopsUser;
		
		if (is_object($xoopsUser)) {
			$root->mController->executeForward(XOOPS_URL);
		}
		else {
			$root->mController->executeForward(XOOPS_MODULE_URL . "/user/index.php?action=UserRegister");
		}
	}
	
	/**
	 * The process for lostpass.php. This process doesn't execute anything
	 * directly. If the current user is registered user, kick out to the top
	 * page. Else, forward to the lost-pass page.
	 */
	function lostpass()
	{
		$root =& XCube_Root::getSingleton();
		$xoopsUser =& $root->mContext->mXoopsUser;

		if (is_object($xoopsUser)) {
			$root->mController->executeForward(XOOPS_URL);
		}
		else {
			$root->mController->executeForward(XOOPS_MODULE_URL . "/user/index.php?action=LostPass");
		}
	}

	/**
	 * The process for user.php. This process doesn't execute anything directly.
	 * Forward to the controller of the user module.
	 */
	function user()
	{
		$root =& XCube_Root::getSingleton();
		$op = isset($_REQUEST['op']) ? trim(xoops_getrequest('op')) : "main";
		$xoopsUser =& $root->mContext->mXoopsUser;
		
		switch($op) {
			case "main":
				$url = is_object($xoopsUser) ? XOOPS_MODULE_URL . "/user/index.php?action=UserInfo&uid=".$xoopsUser->get('uid')
				                               : XOOPS_MODULE_URL . "/user/index.php"; 
				$root->mController->executeForward($url);
				break;
				
			case "delete":
				$root->mController->executeForward(XOOPS_MODULE_URL . "/user/index.php?action=UserDelete");
				break;
				
			case "login":
				$root->mController->checkLogin();
				break;
			
			case "logout":
				$root->mController->logout();
				break;
		}
	}
	
	function checkLogin(&$xoopsUser)
	{
		if (is_object($xoopsUser)) {
			return;
		}

		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadModuleMessageCatalog('user');

		$userHandler =& xoops_getmodulehandler('users', 'user');
		
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('uname', xoops_getrequest('uname')));
		$criteria->add(new Criteria('pass', md5(xoops_getrequest('pass'))));
		
		$userArr =& $userHandler->getObjects($criteria);
		
		if (count($userArr) != 1) {
			return;
		}
		
		if ($userArr[0]->get('level') == 0) {
			// TODO We should use message "_MD_USER_LANG_NOACTTPADM"
			return;
		}
		
		$handler =& xoops_gethandler('user');
		$user =& $handler->get($userArr[0]->get('uid'));
		
		$xoopsUser = $user;
	
		//
		// Regist to session
		//
		require_once XOOPS_ROOT_PATH . '/include/session.php';
		xoops_session_regenerate();
		$_SESSION = array();
		$_SESSION['xoopsUserId'] = $xoopsUser->get('uid');
		$_SESSION['xoopsUserGroups'] = $xoopsUser->getGroups();
		
		//
		// Use 'mysession'
		//
		$xoopsConfig = $root->mContext->mXoopsConfig;
		
		if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
			setcookie($xoopsConfig['session_name'], session_id(), time() + (60 * $xoopsConfig['session_expire']), '/', '', 0);
		}
	}
	
    function checkLoginSuccess(&$xoopsUser)
    {
		if (is_object($xoopsUser)) {
			$handler =& xoops_gethandler('user');
			$xoopsUser->set('last_login', time());
			
			$handler->insert($xoopsUser);
		}
	}

	function logout(&$successFlag, $xoopsUser)
	{
		$root =& XCube_Root::getSingleton();
		$xoopsConfig = $root->mContext->mXoopsConfig;
		
		$root->mLanguageManager->loadModuleMessageCatalog('user');

		// Reset session
		$_SESSION = array();
		session_destroy();

		if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
			setcookie($xoopsConfig['session_name'], '', time()- 3600, '/',  '', 0);
		}

		// clear entry from online users table
		if (is_object($xoopsUser)) {
			$onlineHandler =& xoops_gethandler('online');
			$onlineHandler->destroy($xoopsUser->get('uid'));
		}
		
		$successFlag = true;
    }
	
	function misc()
	{
		if (xoops_getrequest('type') != 'online') {
			return;
		}
		
		require_once XOOPS_MODULE_PATH . "/user/class/ActionFrame.class.php";

		$root =& XCube_Root::getSingleton();
		$root->mController->setupModuleContext('user');
		
		$actionName = "MiscOnline";

		$moduleRunner = new User_ActionFrame(false);
		$moduleRunner->setActionName($actionName);

		$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));

		$root->mController->setDialogMode(true);

		$root->mController->execute();

		$root->mController->executeView();
	}
}

?>