<?php
// $Id: DebuggerManager.class.php,v 1.1.2.2.2.1 2006/10/05 09:07:31 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if (!defined('XOOPS_ROOT_PATH')) exit();

define("XOOPS_DEBUG_OFF",0);
define("XOOPS_DEBUG_PHP",1);
define("XOOPS_DEBUG_MYSQL",2);
define("XOOPS_DEBUG_SMARTY",3);

class Legacy_DebuggerManager
{
	function getInstance($debug_mode)
	{
        static $instance = array();

        if (empty($instance[$debug_mode])) {
            $instance[$debug_mode] =& Legacy_DebuggerManager::_createInstance($debug_mode);
        }
        
        return $instance[$debug_mode];
	}
	
	/**
	Create XoopsDebugger instance.
	You must not communicate with this method directly.
	*/
	function &_createInstance($debug_mode)
	{
		$instance = null;
		switch($debug_mode) {
			case XOOPS_DEBUG_PHP:
				$instance =& new Legacy_PHPDebugger();
				break;

			case XOOPS_DEBUG_MYSQL:
				$instance =& new Legacy_MysqlDebugger();
				break;

			case XOOPS_DEBUG_SMARTY:
				$instance =& new Legacy_SmartyDebugger();
				break;
			
			case XOOPS_DEBUG_OFF:
			default:
				// @todo I can not realize abstract class to instance.
				$instance =& new Legacy_AbstractDebugger();
				break;
		}
		
		return $instance;
	}
}

class Legacy_AbstractDebugger
{
	function Legacy_AbstractDebugger()
	{
	}

	function prepare()
	{
	}
	
	function isDebugRenderSystem()
	{
		return false;
	}

	/**
	 * @return string Log as html code.
	 */	
	function renderLog()
	{
	}
	
	function displayLog()
	{
	}
}

/**
This class works for "PHP debugging mode".
*/
class Legacy_PHPDebugger extends Legacy_AbstractDebugger
{
	function prepare()
	{
		error_reporting(E_ALL);
	}
}

/**
This class works for "Mysql debugging mode".
*/
class Legacy_MysqlDebugger extends Legacy_AbstractDebugger
{
	function renderLog()
	{
		$xoopsLogger =& XoopsLogger::instance();
		return $xoopsLogger->dumpAll();
	}
	
	function displayLog()
	{
        echo '<script type="text/javascript">
        <!--//
        debug_window = openWithSelfMain("", "xoops_debug", 680, 600, true);
        ';
        $content = '<html><head><meta http-equiv="content-type" content="text/html; charset='._CHARSET.'" /><meta http-equiv="content-language" content="'._LANGCODE.'" /><title>'.htmlspecialchars($GLOBALS['xoopsConfig']['sitename']).'</title><link rel="stylesheet" type="text/css" media="all" href="'.getcss($GLOBALS['xoopsConfig']['theme_set']).'" /></head><body>'.$this->renderLog().'<div style="text-align:center;"><input class="formButton" value="'._CLOSE.'" type="button" onclick="javascript:window.close();" /></div></body></html>';
        $lines = preg_split("/(\r\n|\r|\n)( *)/", $content);
        foreach ($lines as $line) {
            echo 'debug_window.document.writeln("'.str_replace('"', '\"', $line).'");';
        }
        echo '
        debug_window.document.close();
        //-->
        </script>';
	}
}


/**
This class works for "Smarty debugging mode".
*/
class Legacy_SmartyDebugger extends Legacy_AbstractDebugger
{
	function isDebugRenderSystem()
	{
		$root =& XCube_Root::getSingleton();
		$user =& $root->mContext->mXoopsUser;
		
		return is_object($user) ? $user->isAdmin(0) : false;
	}
}

?>