<?php
/**
 * @package Legacy
 * @version $Id: Legacy_HttpContext.class.php,v 1.1.2.3 2006/10/06 09:48:12 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/modules/base/kernel/Legacy_Module.class.php";

/**
 * The context class for Legacy which extends to keep Legacy-module-specific
 * informations.
 */
class Legacy_HttpContext extends XCube_HttpContext
{
	/**
	 * The current user profile object.
	 * @var XoopsUser
	 */
	var $mXoopsUser = null;

	/**
	 * The current module instance.
	 */	
	var $mModule = null;
	
	/**
	 * The current Xoops Module object. This is a shortcut to mModule->mXoopsModule.
	 * @access public
	 * @var XoopsModule
	 */
	var $mXoopsModule = null;
	
	/**
	 * The array for Xoops, which is configured in the preference of the base.
	 * This property and $xoopsConfig (X2) is the same.
	 */
	var $mXoopsConfig = array();
	
	/**
	 * The array for Xoops Module Config. This is a short cut to mModule->mConfig.
	 * @access public
	 * @var array
	 */
	var $mModuleConfig = array();
	
	/**
	 * A name of the render system used by the controller strategy.
	 */
	var $mBaseRenderSystemName = "";
	
	/**
	 * Gets a value of XoopsConfig by $id.
	 * @param string $id
	 * @return string
	 */
	function getXoopsConfig($id = null)
	{
		if ($id != null) {
			return isset($this->mXoopsConfig[$id]) ? $this->mXoopsConfig[$id] : null;
		}

		return $this->mXoopsConfig;
	}

}

?>